    clear all;
    close all;

%File details
    delimiterIn = ',';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end
    
    r=[0:0.1:16] 
    y = zeros(length(r),1);
    figure;
    hold on;
   % plot(r,y,'--k');
    
    
    n = 10;
    for i = 1:n
   
%Open the datafile
    FilterSpec = '.dat';

    DialogTitle = 'Select file with H/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end
   
%Save to Data    
    plot(Data(:,1),Data(:,2));
    
    
    end

  
    
    xlabel('H (T)','fontsize',20,'fontname','times');
    xlim([0 16]);
    ylabel('R_{xy} (\Omega)','fontsize',20,'fontname','times');
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    set(findall(gca, 'Type', 'Line'),'LineWidth',2);
    H_lin = 0:0.1:16;
    f_H_lin = H_lin.*0.07188;
    plot(H_lin,f_H_lin,'--k');
    set(gcf, 'Position', [250, 250, 600, 600])
    %title('FeSeLF9 R_{xx} component');
    box on;
    hold off;
    
        
    